#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#define		MON_FIFO	"/dev/shm/.ghelper"
#define		BUF_SIZE	128
#define		MAX_PATH	128

int invalidate_check(char *trans);

int main(int argc, char *argv[])
{
	struct stat gstat;
	FILE *fp, *ofp;
	unsigned int arglen = 0, ign_scripts_log = 0;
	char gein_hint[]={
		"[BASH-GEINPEEK MONITOR]\n"	
		"[Hint: when if you have to stop it 'CTRL+C']\n"
	};
	char usage[]={
		"Usage: %s [output file] [option]\n"
		"\t-i : ignore output of the command's logs in shell-script\n"
	};

	char out_filename[MAX_PATH];
	char rbuf[BUF_SIZE];
	
	memset(out_filename, 0, MAX_PATH);
	memset(rbuf, 0, BUF_SIZE);

	if(argc < 2){
		fprintf(stdout, usage, argv[0]);
		return(1);
	}
		
	/* This program only runs for root user */
	if(geteuid() != 0){
		fprintf(stderr, "You must be root(uid=0)\n");
		return(2);
	}

	if((arglen = strlen(argv[1])) >= MAX_PATH){
		fprintf(stderr, "output filename is too long\n");
		return(3);
	}

	strncpy(out_filename, argv[1], arglen);

	/* set flag for ignoring standard output for command's logs in shell-script */
	if(argc == 3 && strcmp(argv[2], "-i") == 0)
		ign_scripts_log = 1;

	/* re-creating fifo file */
	unlink(MON_FIFO);
	umask(0);	
	mknod(MON_FIFO, S_IFIFO | 0622, 0);

	printf("%s", gein_hint);

	/* write split line to outfile */

        if((ofp = fopen(out_filename, "a+")) <= 0){
	        fprintf(stderr, "I can't open ( %s :OUTPUT FILE )\n", out_filename);
        }
	fprintf(ofp, "\n\n+----------------------------------------------------+\n\n");
	fclose(ofp);


	for(;;){
		/* open fifo file for read-only */
		if((fp = fopen(MON_FIFO, "r")) <= 0){
			fprintf(stderr, "I can't open ( %s :FIFO )\n", MON_FIFO);
			return(4);
		}
	
	        if((ofp = fopen(out_filename, "a+")) <= 0){
        	        fprintf(stderr, "I can't open ( %s :OUTPUT FILE )\n", out_filename);
	        }
	
		memset(rbuf, 0, BUF_SIZE);
		
		/* reading multiple user's command supplied by bash shell patched geinpeek kit */
		fgets(rbuf, BUF_SIZE, fp);

		if(invalidate_check(rbuf) == 0){
			fprintf(ofp, "%s", rbuf);

			if((ign_scripts_log == 1) && (rbuf[0] == '!' && rbuf[1]=='s' && rbuf[2]=='!')){
				/* blank */
			} else{
				printf("%s", rbuf);
			}
		}
	
		fclose(ofp);			
		fclose(fp);
	}	
	
}

int invalidate_check(char *trans)
{

        if(*(trans + 25) == '-' && *(trans + 27) == '[')
                return 0;
        else
                return -1;

}

