#!/usr/bin/perl -w
# buildPie.pl - build a simple pie chart using modified GD::Pie.pm
# http://ulissesaraujo.wordpress.com/2008/12/08/deploying-honeypots-with-honeyd/

BEGIN {
        push @INC,"/etc/scripts";
}

use strict;
use lib qw(./);
use customPie;

if( @ARGV != 1 ){ die "specify an output filename" }

my( @name, @ratio ) = ();
my $filename = $ARGV[0];

chomp($filename);
while(<STDIN>){
  my @parts = split "#", $_;
  push @name, $parts[2];
  push @ratio, $parts[1];
}#while stdin

my $mygraph = GD::Graph::pie->new(600,600);
# colors of the pie slices
#$mygraph->set( dclrs => [ "#2E2E2E","#6E6E6E","#FFFFFF","#2E2E2E",
$mygraph->set( dclrs => [ "#6262D0","#4646D3","#2929D9","#0101DF" ] );
                          #"#6262D0","#4646D3","#2929D9","#0101DF" ] );
# color of pie divisors
$mygraph->set( accentclr => '#000000');
$mygraph->set( '3d' =>'0');
my @togr = ( [@name], [@ratio] );

my $myimage = $mygraph->plot(\@togr) or die $mygraph->error;

open(IMG, "> $filename.pie.png") or die $1;
  binmode IMG;
  print IMG $myimage->png;
close(IMG);

