#!/usr/bin/perl -w
# Author: Joshua Gimer <jgimer@gmail.com>
# Last Update: Tue Feb 10 18:15:08 MST 2009
# Version: 1.0
#

use strict;
use DBI;

my $logfile='/var/log/honeyd.log';

my $username = 'honeyd';
my $database = 'honeyd_data';
my $pw='';

open(FILE, "$logfile");

# Uncomment the line below and comment out other connect line for mysql
# You may need to switch the VALUES line below also for Mysql
#my $dbh = DBI->connect("DBI:mysql:$database",
my $dbh = DBI->connect("DBI:Pg:dbname=$database",
	$username,$pw,{RaiseError => 1});
printf "Connecting to Database $database\n";

while (<FILE>) {

printf "Checking: $_\n";
if (!($_ =~ /honeyd log started/)) {
printf "Line Passed Check\n";

	my ($date_time, $proto, $junk,
        $src_ip, $src_port, $dest_ip, $dest_port);

	if ( (/icmp/) || (/dsr/) || (/gre/) ) {

	($date_time, $proto, $junk, 
        $src_ip, $dest_ip, $dest_port) = split(/ /, "$_");

	$dest_port =~ s/\(\d+\):?//;
	$src_port = '00';

	} else {

	($date_time, $proto, $junk, 
	$src_ip, $src_port, $dest_ip, $dest_port) = split(/ /, "$_"); 

	}

	$date_time =~ s/-(\d\d):/ $1:/;
	$date_time =~ s/\.\d.*$//;

	$proto =~ s/\(\d\)//;
	$proto =~ s/\s/udp/;
	$proto =~ s/\(\d+\)//;
	$dest_port =~ s/://;

	printf "Inserting Values:\nDate-Time: $date_time\nProtocol: $proto\nSource IP and Port: $src_ip:$src_port\nDestination IP and Port: $dest_ip:$dest_port\n";
	$dbh->do("INSERT INTO connection (date_time,proto,source_ip,source_port,dest_ip,dest_port) 
	VALUES(\'$date_time\', \'$proto\', \'$src_ip\', \'$src_port\', \'$dest_ip\', \'$dest_port\');") or warn $dbh->errstr;
	#VALUES(\"$date_time\", \"$proto\", \"$src_ip\", \"$src_port\", \"$dest_ip\", \"$dest_port\");") or warn $dbh->errstr;

}

}

$dbh->do("UPDATE connection set proto = 'udp' where proto='';");

close(FILE);
