#!/usr/bin/perl -w
# Author: Joshua Gimer <jgimer@gmail.com>
# Last Update: Tue Feb 10 18:15:08 MST 2009
# Version: 1.0
#

use strict;
use File::Tail;
use DBI;

my $logfile='/var/log/honeyd.log';

my $username = 'honeyd_logger';
my $database = 'honeyd_data';
my $pw='';

my $file=File::Tail->new(name=>"$logfile", maxinterval=>10);

my $dbh = DBI->connect("DBI:mysql:$database",
	$username,$pw,{RaiseError => 1});
#printf "Connecting to Database $database\n";

while (defined(my $line=$file->read)) {

#printf "Checking: $line\n";
if (!($line =~ /honeyd log started/)) {
#printf "Line Passed Check\n";

	my ($date_time, $proto, $junk, 
	$src_ip, $src_port, $dest_ip, $dest_port) = split(/ /, "$line");

	$date_time =~ s/-(\d\d):/ $1:/;
	$date_time =~ s/\.\d.*$//;

	$proto =~ s/\(\d\)//;
	$proto =~ s/\s/udp/;
	$dest_port =~ s/://;

#	printf "Inserting Values:\nDate-Time: $date_time\nProtocol: $proto\nSource IP and Port: $src_ip:$src_port\nDestination IP and Port: $dest_ip:$dest_port\n";
	$dbh->do("INSERT INTO connection (date_time,proto,source_ip,source_port,dest_ip,dest_port) 
	VALUES(\"$date_time\", \"$proto\", \"$src_ip\", \"$src_port\", \"$dest_ip\", \"$dest_port\");") or warn $dbh->errstr;

	$dbh->do("UPDATE connection set proto = 'udp' where proto='';");

}

}
