#!/usr/bin/perl -w
# Author: Joshua Gimer <jgimer@gmail.com>
# Last Update: Tue Feb 10 18:15:08 MST 2009
# Version: 1.0

use strict;
use DBI;

my $username = 'honeyd';
my $database = 'honeyd_data';
my $pw='';

print "Content-Type: text/html\n\n";

print "<HTML>\n<HEAD><link rel=\"stylesheet\" type=\"text/css\" href=\"tables2.css\" /><TITLE>HoneyD Port Statistics</TITLE></HEAD>\n<BODY>\n";

#my $dbh = DBI->connect("DBI:mysql:dbname=$database",
my $dbh = DBI->connect("DBI:Pg:dbname=$database",
	$username,$pw,{RaiseError => 1});

my $sth = $dbh->prepare("SELECT dest_port, COUNT(dest_port) AS count from connection where proto='tcp' GROUP BY dest_port ORDER BY count DESC LIMIT 100;") or
		die "Unable to prep the query:". $dbh->errstr . "\n";

my $sth2 = $dbh->prepare("SELECT dest_port, COUNT(dest_port) AS count from connection where proto='udp' GROUP BY dest_port ORDER BY count DESC LIMIT 100;") or
		die "Unable to prep the query:". $dbh->errstr . "\n";

my $sth3 = $dbh->prepare("SELECT source_port, COUNT(source_port) AS count from connection where proto='tcp' GROUP BY source_port ORDER BY count DESC LIMIT 100;") or
		die "Unable to prep the query:". $dbh->errstr . "\n";

my $sth4 = $dbh->prepare("SELECT source_port, COUNT(source_port) AS count from connection where proto='udp' GROUP BY source_port ORDER BY count DESC LIMIT 100;") or
		die "Unable to prep the query:". $dbh->errstr . "\n";

my $rc = $sth->execute or die "Unable to execute our query:" . $dbh->errstr . "\n";
my $rc2 = $sth2->execute or die "Unable to execute our query:" . $dbh->errstr . "\n";
my $rc3 = $sth3->execute or die "Unable to execute our query:" . $dbh->errstr . "\n";
my $rc4 = $sth4->execute or die "Unable to execute our query:" . $dbh->errstr . "\n";

my $dest_port;
my $dest_udp_port;
my $dest_port_count;
my $dest_udp_port_count;
my $source_tcp_port;
my $source_tcp_port_count;
my $source_udp_port;
my $source_udp_port_count;

$rc = $sth->bind_columns(\$dest_port,\$dest_port_count);
$rc2 = $sth2->bind_columns(\$dest_udp_port,\$dest_udp_port_count);
$rc3 = $sth3->bind_columns(\$source_tcp_port,\$source_tcp_port_count);
$rc4 = $sth4->bind_columns(\$source_udp_port,\$source_udp_port_count);

print "<TABLE border=0 cellspacing=\"0%\">\n";
print "<TR>\n";
print "<TD>\n";
print "<table class=\"stats\" cellspacing=\"0\">\n";
print "<tr>\n";
print "<td class=\"hed\" colspan=2>Top 100 Connections by Destination TCP Port</td></tr>\n";

while ($sth->fetchrow_arrayref) {

	print "<tr><td><a href=\"http://www.dshield.org/port.html?port=$dest_port\" target=\"_blank\">$dest_port/tcp</a></td><td>$dest_port_count</td></tr>\n";

}

print "</table>\n";
print "</TD>\n";

print "<TD>\n";
print "<table class=\"stats\" cellspacing=\"0\">\n";
print "<td class=\"hed\" colspan=2>Top 100 Connections by Destination UDP Port</td></tr>\n";

while ($sth2->fetchrow_arrayref) {

	print "<tr><td><a href=\"http://www.dshield.org/port.html?port=$dest_udp_port\" target=\"_blank\">$dest_udp_port/udp</a></td><td>$dest_udp_port_count</td></tr>\n";

}

print "</table>\n";
print "</TD>\n";

print "<TD>\n";
print "<table class=\"stats\" cellspacing=\"0\">\n";
print "<td class=\"hed\" colspan=2>Top 100 Connections by Source TCP Port</td></tr>\n";

while ($sth3->fetchrow_arrayref) {

        print "<tr><td><a href=\"http://www.dshield.org/port.html?port=$source_tcp_port\" target=\"_blank\">$source_tcp_port/tcp</a></td><td>$source_tcp_port_count</td></tr>\n";

}

print "</table>\n";
print "</TD>\n";

print "<TD>\n";
print "<table class=\"stats\" cellspacing=\"0\">\n";
print "<td class=\"hed\" colspan=2>Top 100 Connections by Source UDP Port</td></tr>\n";

while ($sth4->fetchrow_arrayref) {

        print "<tr><td><a href=\"http://www.dshield.org/port.html?port=$source_udp_port\" target=\"_blank\">$source_udp_port/udp</a></td><td>$source_udp_port_count</td></tr>\n";

}

print "</table>\n";
print "</TD>\n";


print "</TR>\n";
print "</table>\n";
print "</table>\n";

$sth->finish;
$sth2->finish;
$dbh->disconnect;
