#!/usr/bin/perl -w
# Author: Joshua Gimer <jgimer@gmail.com>
# Last Update: Tue Feb 10 18:15:08 MST 2009
# Version: 1.0
#

use strict;
use RRD::Simple ();

# Make sure to change the egrep command below to reflect your honeyd netrange

my $honeyd_log = '/var/log/honeyd.log';
my $rrd_db = '/tmp/traffic.rrd';  

system("rm -f $rrd_db");

my $rrd = RRD::Simple->new( file => "$rrd_db" );

$rrd->create( connections => "GAUGE" );

my %info;

system("cp $honeyd_log /tmp/");

while () {

sleep 60;

system("mv /tmp/honeyd.log /tmp/honeyd.log.old 2>/dev/null; cp $honeyd_log /tmp/honeyd.log 2>/dev/null");
my @lines = `diff /tmp/honeyd.log /tmp/honeyd.log.old | egrep '10\.26' | sed 's/< //' | sed 's/> //'`;

foreach (@lines) {
  
$info{'counter'} += 1;
#printf "Updating counter\n";

}

#printf "Updating data $info{'counter'}\n";
$rrd->update( connections => $info{'counter'} );

undef(%info);

}
