// created on 03.02.2005 at 14:56
using System;
using Gtk;
using Glade;
using System.IO;
using Mono.Posix;
using System.Threading;

public class MainWindow
{
	[Glade.Widget] Gtk.Button btnExit;
	[Glade.Widget] Gtk.Button btnScan;
	[Glade.Widget] Gtk.TextView txtvView;
	[Glade.Widget] Gtk.Label lblRelayHost;
	[Glade.Widget] Gtk.Label lblRange;
	[Glade.Widget] Gtk.Label lblAckPort;
	[Glade.Widget] Gtk.Label lblTcpSyn;
	[Glade.Widget] Gtk.Label lblUdpPing;
	[Glade.Widget] Gtk.ComboBox cbScanType;
	[Glade.Widget] Gtk.ComboBox cbPorts;
	[Glade.Widget] Gtk.ComboBox cbReverseDns;
	[Glade.Widget] Gtk.ComboBox cbVerbosity;
	[Glade.Widget] Gtk.ComboBox cbThrottling;
	[Glade.Widget] Gtk.CheckButton chkOsDetection;
	[Glade.Widget] Gtk.CheckButton chkIdentd;
	[Glade.Widget] Gtk.CheckButton chkRPC;
	[Glade.Widget] Gtk.CheckButton chkVersion;
	[Glade.Widget] Gtk.CheckButton chkPing;
	[Glade.Widget] Gtk.CheckButton ckIcmpEcho;
	[Glade.Widget] Gtk.CheckButton ckTcpAck;
	[Glade.Widget] Gtk.CheckButton ckIcmpTimestamp;
	[Glade.Widget] Gtk.CheckButton ckIcmpNetmask;
	[Glade.Widget] Gtk.CheckButton ckTcpSyn;
	[Glade.Widget] Gtk.CheckButton ckUdpPing;
	[Glade.Widget] Gtk.CheckButton ckDevice;
	[Glade.Widget] Gtk.CheckButton ckPort;
	[Glade.Widget] Gtk.CheckButton ckIP;
	[Glade.Widget] Gtk.CheckButton ckDecoy;
	[Glade.Widget] Gtk.CheckButton ckFragmentation;
	[Glade.Widget] Gtk.CheckButton ckIPv6;
	[Glade.Widget] Gtk.CheckButton ckOrderedPorts;
	[Glade.Widget] Gtk.CheckButton ckTTL;
	[Glade.Widget] Gtk.CheckButton ckMinParallel;
	[Glade.Widget] Gtk.CheckButton ckMaxParallel;
	[Glade.Widget] Gtk.CheckButton ckInitRTT;
	[Glade.Widget] Gtk.CheckButton ckMinRTT;
	[Glade.Widget] Gtk.CheckButton ckMaxRTT;
	[Glade.Widget] Gtk.CheckButton ckHostTimeout;
	[Glade.Widget] Gtk.CheckButton ckScanDelay;
	[Glade.Widget] Gtk.CheckButton ckInputFile;
	[Glade.Widget] Gtk.CheckButton ckOutputFile;
	[Glade.Widget] Gtk.Entry txtTarget;
	[Glade.Widget] Gtk.Entry txtRange;
	[Glade.Widget] Gtk.Entry txtRelayHost;
	[Glade.Widget] Gtk.Entry txtCommand;
	[Glade.Widget] Gtk.Entry txtScanTxt;
	[Glade.Widget] Gtk.Entry txtAckPort;
	[Glade.Widget] Gtk.Entry txtTcpSyn;
	[Glade.Widget] Gtk.Entry txtUdpPing;
	[Glade.Widget] Gtk.Entry txtDevice;
	[Glade.Widget] Gtk.Entry txtPort;
	[Glade.Widget] Gtk.Entry txtIP;
	[Glade.Widget] Gtk.Entry txtDecoy;
	[Glade.Widget] Gtk.Entry txtInput;
	[Glade.Widget] Gtk.Entry txtOutput;
	[Glade.Widget] Gtk.Frame fPing;
	[Glade.Widget] Gtk.Frame fPorts;
	[Glade.Widget] Gtk.Frame fSource; 
	[Glade.Widget] Gtk.Frame fMOptions;
	[Glade.Widget] Gtk.SpinButton sbTTL;
	[Glade.Widget] Gtk.SpinButton sbMinParallel;
	[Glade.Widget] Gtk.SpinButton sbMaxParallel;
	[Glade.Widget] Gtk.SpinButton sbInitRTT;
	[Glade.Widget] Gtk.SpinButton sbMinRTT; 
	[Glade.Widget] Gtk.SpinButton sbMaxRTT;
	[Glade.Widget] Gtk.SpinButton sbHostTimeout;
	[Glade.Widget] Gtk.SpinButton sbScanDelay;	
	[Glade.Widget] Gtk.HBox ghThrottle;
	[Glade.Widget] Gtk.HBox hbInput;
	[Glade.Widget] Gtk.HBox hbOutput;
	[Glade.Widget] Gtk.VBox gvRTT;
	[Glade.Widget] Gtk.VBox gvRTT2;
	[Glade.Widget] Gtk.VBox gvms;
	
	Gtk.TextBuffer buffer;
	int value;
    Thread th;
    bool threads;
    int uid;
	ThreadNotify notify;
	StreamReader sr1,sr2;
	string throttling="";
	string throttling_etc="";
    string parametri;
	string scanValue;
	string scannedPorts;
	string Discover="-P0 ";
	string reversedns="";
	string verbosity="";
	string Scan_ex="";
	string Source="";
	string[] scan_user={"Connect Scan","Ping Sweep","Host List","FTP Bounce Atack"};
	string[] scan_root={"Connect Scan","Syn Stealth Scan","ACK Stealth Scan","FIN|ACK Stealth Scan","FIN Stealth Scan","NULL Stealth Scan","XMas Tree Stealth Scan","TCP Window Scan","UDP Port Scan","IP Protocol Scan","Ping Sweep","Host List","FTP Bounce Atack","Idle Scan"};
	string[] ports={"Default","All","Most Important [fast]","Range Given Below"};
    string[] ReverseDns={"Always","When Required","Never"};
    string[] Verbosity={"Quiet","Verbose","Very Verbose","Debug","Verbose Debug"};
    string[] Throttling={"Paranoid Throttling","Sneaky Throttling","Polite Throttling","Normal Throttling","Agressive Throttling","Insane Throttling"};

	
	public MainWindow()
	{
		Application.Init();
		Glade.XML gxml = new Glade.XML (null, "gui.glade", "window1", null);
		gxml.Autoconnect (this);
        
	    uid=Syscall.getuid();	    
        notify = new ThreadNotify (new ReadyEvent (ready));
        
	    //====================================
		TreeStore store_reversedns=new TreeStore(typeof(string));
	    TreeStore store_verbosity=new TreeStore(typeof(string));        
	    TreeStore store_scan=new TreeStore(typeof(string));
        TreeStore store_ports=new TreeStore(typeof(string));
	    TreeStore store_throttle=new TreeStore(typeof(string));
        TreeIter iter_scan= new TreeIter();
	    TreeIter iter_ports= new TreeIter();
        TreeIter iter_reversedns= new TreeIter();
	    TreeIter iter_verbosity= new TreeIter();
	    TreeIter iter_throttle= new TreeIter();
        buffer=txtvView.Buffer;
	    //default options =====================	
	    scanValue="-sT ";
	    scannedPorts="-F ";
	    comanda();	
	    if(uid==0){
			fSource.Sensitive=true;
			fMOptions.Sensitive=true;
			ghThrottle.Sensitive=true;
			gvRTT.Sensitive=true;
			gvRTT2.Sensitive=true;
			gvms.Sensitive=true;
			ckIcmpEcho.Active =true;
			ckTcpAck.Active = true;
		}
		else{
			ckTcpAck.Active = true;
		}
	    //ports combobox        
		for(int i=0;i< ports.Length;i++)
			store_ports.AppendValues(ports[i]);
		TreePath tp1 = new TreePath();
		cbPorts.Model =store_ports;
	    tp1.AppendIndex(2);
	    store_ports.GetIter(out iter_ports,tp1);     
	    cbPorts.SetActiveIter(iter_ports);
	    //scan combobox
	    if(uid!=0){
			for(int i=0;i< scan_user.Length;i++)
				store_scan.AppendValues(scan_user[i]);
			chkOsDetection.Sensitive=false;
			buffer.Text="You are *NOT* root - Some options aren't available.";
			chkOsDetection.Active=false;
		}
	    else{
			for(int i=0;i< scan_root.Length;i++)
				store_scan.AppendValues(scan_root[i]);
			buffer.Text="You are root - All options granted.";
		}
	    cbScanType.Model =store_scan;
	    store_scan.GetIterFirst(out iter_scan);
	    cbScanType.SetActiveIter(iter_scan);
	    //Reverse dns comboxbox
	    for(int i=0;i<ReverseDns.Length;i++)
			store_reversedns.AppendValues(ReverseDns[i]);
		TreePath tp2 = new TreePath();
	    cbReverseDns.Model=store_reversedns;
	    tp2.AppendIndex(1);
	    store_reversedns.GetIter(out iter_reversedns,tp2);
	    cbReverseDns.SetActiveIter(iter_reversedns);
	    //Verbosity combobox
	    for(int i=0;i<Verbosity.Length;i++)
			store_verbosity.AppendValues(Verbosity[i]);
	    cbVerbosity.Model =store_verbosity;
	    store_verbosity.GetIterFirst(out iter_verbosity);
	    cbVerbosity.SetActiveIter(iter_verbosity);
	    //Throttling combobox
	    for(int i=0;i<Throttling.Length;i++)
		    store_throttle.AppendValues(Throttling[i]);
		TreePath tp3 = new TreePath();
		cbThrottling.Model=store_throttle;
		tp3.AppendIndex(3);
		
	    store_throttle.GetIter(out iter_throttle,tp3);
		cbThrottling.SetActiveIter(iter_throttle);
        Application.Run();
	}
	//quit
	public void on_window1_delete_event(object o, DeleteEventArgs args)
	{
		if(threads==true)
			th.Abort();
		Application.Quit ();
	}
	public void on_btnExit_clicked(object o, EventArgs args)
	{	    
		if(threads==true)
			th.Abort();
		Application.Quit();	    	    
	}
	//scan button
	public void on_btnScan_clicked(object o, EventArgs args)
	{
		th = new Thread (new ThreadStart(scan));
		th.IsBackground = true;
		th.Start();
		threads=true;
		btnScan.Sensitive=false;

			}
	//=======
	public void on_cbScanType_changed(object o, EventArgs args)
	{
		TreeIter ti;
	    fPorts.Sensitive = true;
	    lblRelayHost.Text = "    Relay Host:  ";
	    scannedPorts="-F ";
	    if(cbScanType.GetActiveIter(out ti)){
			string s=(string)cbScanType.Model.GetValue(ti,0);
			if(s=="Connect Scan"){
				chkIdentd.Sensitive=true; chkVersion.Sensitive=true; chkRPC.Sensitive=true; chkOsDetection.Sensitive=true;
				scanValue="-sT ";
				lblRelayHost.Sensitive=false; txtRelayHost.Sensitive=false;
			}
			else if(s=="Syn Stealth Scan"){
				chkIdentd.Sensitive=false; chkVersion.Sensitive=true; chkRPC.Sensitive=true; chkOsDetection.Sensitive=true;
				scanValue="-sS ";
				lblRelayHost.Sensitive=false; txtRelayHost.Sensitive=false;
			}
			else if (s=="ACK Stealth Scan"){
				chkIdentd.Sensitive=false; chkVersion.Sensitive=true; chkRPC.Sensitive=true; chkOsDetection.Sensitive=true;
				scanValue="-sA ";
				lblRelayHost.Sensitive=false; txtRelayHost.Sensitive=false;
			}
			else if (s=="FIN|ACK Stealth Scan"){
				chkIdentd.Sensitive=false; chkVersion.Sensitive=true; chkRPC.Sensitive=true; chkOsDetection.Sensitive=true;
				scanValue="-sM ";
				lblRelayHost.Sensitive=false; txtRelayHost.Sensitive=false;
			}
			else if (s=="FIN Stealth Scan"){
				chkIdentd.Sensitive=false; chkVersion.Sensitive=true; chkRPC.Sensitive=true; chkOsDetection.Sensitive=true;
				scanValue="-sF ";      	   
				lblRelayHost.Sensitive=false; txtRelayHost.Sensitive=false;
			}
			else if (s=="NULL Stealth Scan"){
				chkIdentd.Sensitive=false; chkVersion.Sensitive=true; chkRPC.Sensitive=true; chkOsDetection.Sensitive=true;
				scanValue="-sN ";
				lblRelayHost.Sensitive=false; txtRelayHost.Sensitive=false;
			}
			else if (s=="XMas Tree Stealth Scan"){
				chkIdentd.Sensitive=false; chkVersion.Sensitive=true; chkRPC.Sensitive=true; chkOsDetection.Sensitive=true;
				scanValue="-sX ";
				lblRelayHost.Sensitive=true; txtRelayHost.Sensitive=true;
			}
			else if (s=="TCP Window Scan"){
				chkIdentd.Sensitive=false; chkVersion.Sensitive=true; chkRPC.Sensitive=true; chkOsDetection.Sensitive=true;
				scanValue="-sW ";
				lblRelayHost.Sensitive=false; txtRelayHost.Sensitive=false;
			}
			else if (s=="UDP Port Scan"){
				chkIdentd.Sensitive=false; chkVersion.Sensitive=true; chkRPC.Sensitive=true; chkOsDetection.Sensitive=true;
				scanValue="-sU ";
				lblRelayHost.Sensitive=false; txtRelayHost.Sensitive=false;
			}
			else if (s=="IP Protocol Scan"){
				chkIdentd.Sensitive=false; chkVersion.Sensitive=false; chkRPC.Sensitive=false; chkOsDetection.Sensitive=true;
				scanValue="-sO ";
				lblRelayHost.Sensitive=false; txtRelayHost.Sensitive=false;
			}
			else if(s=="Ping Sweep"){
				scanValue="-sP ";
				Discover="-PI ";
				lblRelayHost.Sensitive = false; txtRelayHost.Sensitive=false;
				chkIdentd.Sensitive=false; chkVersion.Sensitive=false; chkRPC.Sensitive=false; chkOsDetection.Sensitive=false;
				fPorts.Sensitive = false;
				scannedPorts="";
			}
			else if(s=="Host List"){
				scanValue="-sL ";
				chkIdentd.Sensitive=false; chkVersion.Sensitive=false; chkRPC.Sensitive=false; chkOsDetection.Sensitive=false;
				lblRelayHost.Sensitive = false; txtRelayHost.Sensitive=false;
				fPorts.Sensitive = false;
				scannedPorts="";
			}
			else if(s=="FTP Bounce Atack"){
				scanValue="-b "+"127.0.0.1 ";
				lblRelayHost.Text = "    Bounce Host:  ";
				lblRelayHost.Sensitive = true; txtRelayHost.Sensitive = true;
				value=1;
			}
			else if (s=="Idle Scan"){
				scanValue="-sI ";
				lblRelayHost.Text = "    Zombie Host:  ";
				lblRelayHost.Sensitive = true; txtRelayHost.Sensitive = true;
				value=2;
			}
		}
		comanda();
	}
	public void on_cbPorts_changed(object o, EventArgs args)
	{
		TreeIter ti;
		if(cbPorts.GetActiveIter(out ti)){
			string s=(string)cbPorts.Model.GetValue(ti,0);
			if(s=="Default"){
				scannedPorts ="";
				lblRange.Sensitive = false; txtRange.Sensitive = false;
			}
			else if(s=="All"){
				scannedPorts ="-p- ";
				lblRange.Sensitive = false; txtRange.Sensitive = false;
			}
			else if(s=="Most Important [fast]"){
				scannedPorts ="-F ";
				lblRange.Sensitive = false; txtRange.Sensitive = false;
			}
			else if(s=="Range Given Below"){
				lblRange.Sensitive = true; txtRange.Sensitive = true;
			}
		}
		comanda();
	}
	public void on_cbReverseDns_changed(object o, EventArgs args)
	{
		TreeIter ti;
		if(cbReverseDns.GetActiveIter(out ti)){
			string s=(string)cbReverseDns.Model.GetValue(ti,0);
			if(s=="Always"){
				reversedns="-R ";
			}
			else if(s=="When Required"){       
				reversedns="";
			}
			else if(s=="Never"){
				reversedns="-n ";
			}
		}
		comanda();
	}
	public void on_cbVerbosity_changed(object o, EventArgs args)
	{
		TreeIter ti;
		if(cbVerbosity.GetActiveIter(out ti)){
			string s=(string)cbVerbosity.Model.GetValue(ti,0);
			if(s=="Quiet"){
				verbosity="";
			}
			else if(s=="Verbose"){       
				verbosity="-v ";
			}
			else if(s=="Very Verbose"){
				verbosity="-vv ";    
			}
			else if(s=="Debug"){
				verbosity="-d ";
			}
			else if(s=="Verbose Debug"){
				verbosity="-d2 ";
			}
		}
		comanda();
	}
	public void on_cbThrottling_changed(object o, EventArgs args)
	{
		TreeIter ti;
		if(cbThrottling.GetActiveIter(out ti)){
			string s=(string)cbThrottling.Model.GetValue(ti,0);
			if(s=="Paranoid Throttling"){
				throttling="-T0 ";
			}
			else if(s=="Sneaky Throttling"){
				throttling="-T1 ";
			}
			else if(s=="Polite Throttling"){
				throttling="-T2 ";
			}
			else if(s=="Normal Throttling"){
				throttling="";
			}
			else if(s=="Agressive Throttling"){
				throttling="-T4 ";
			}
			else if(s=="Insane Throttling"){
				throttling="-T5 ";
			}
		}
		comanda();
	}
	public void on_txtRelayHost_changed(object o, EventArgs args)
	{
		if(txtRelayHost.Text!=""){
			if(value==1)
				scanValue="-b "+txtRelayHost.Text+" ";  		       
			else 
				scanValue="-sL "+txtRelayHost.Text+" ";
		}  
		comanda();
	}
	public void on_txtRange_changed(object o, EventArgs args)
	{
		scannedPorts="-p "+txtRange.Text+" ";
		comanda();
	}
	public void on_txtTarget_changed(object o, EventArgs args)
	{
		comanda();
	}
	public void on_chkRPC_toggled(object o, EventArgs args)
	{
		comanda();
	}	
	public void on_chkIdentd_toggled(object o, EventArgs args)
	{
	    comanda();
	}
	public void on_chkOsDetection_toggled(object o, EventArgs args)
	{
	    comanda();
	}
	public void on_chkVersion_toggled(object o, EventArgs args)
	{
	    comanda();
	}
	public void on_chkPing_toggled(object o, EventArgs args)
	{
	    comanda();
	}
	public void on_ckIcmpEcho_toggled(object o, EventArgs args)
	{
		comanda();
	}
	public void on_ckTcp_Ack_toggled(object o, EventArgs args)
	{
		if(ckTcpAck.Active ==true ){ lblAckPort.Sensitive=true; txtAckPort.Sensitive=true; }
		else{ lblAckPort.Sensitive=false; txtAckPort.Sensitive=false; }
		comanda();
	}
	public void on_txtAckPort_changed(object o, EventArgs args)
	{
	    comanda();
	}
	public void on_txtUdpPing_changed(object o, EventArgs args)
	{
	    comanda();
	}
	public void on_txtTcpSyn_changed(object o, EventArgs args)
	{
	    comanda();
	}
	public void on_ckIcmpTimestamp_toggled(object o, EventArgs args)
	{
	    comanda();
	}
	public void on_ckIcmpNetmask_toggled(object o, EventArgs args)
	{
	    comanda();
	}
	public void on_ckTcpSyn_toggled(object o, EventArgs args)
	{
	    if(ckTcpSyn.Active == true) { lblTcpSyn.Sensitive=true;txtTcpSyn.Sensitive=true; }
	    else { lblTcpSyn.Sensitive=false;txtTcpSyn.Sensitive=false; }
	    comanda();
	}
	public void on_ckUdpPing_toggled(object o, EventArgs args)
	{
	    if(ckUdpPing.Active == true) { lblUdpPing.Sensitive=true;txtUdpPing.Sensitive=true; }
	    else { lblUdpPing.Sensitive=false;txtUdpPing.Sensitive=false; }
	    comanda();
	}
	public void on_ckDevice_toggled(object o, EventArgs args)
	{
	    if(ckDevice.Active==true) txtDevice.Sensitive=true; else txtDevice.Sensitive=false;
	    comanda();
	}
	public void on_ckPort_toggled(object o, EventArgs args)
	{
	    if(ckPort.Active==true) txtPort.Sensitive=true; else txtPort.Sensitive=false;
	    comanda();
	}
	public void on_ckIP_toggled(object o, EventArgs args)
	{
	   if(ckIP.Active==true) txtIP.Sensitive=true; else txtIP.Sensitive=false;
	   comanda();
	}
	public void on_ckDecoy_toggled(object o, EventArgs args)
	{
	   if(ckDecoy.Active==true) txtDecoy.Sensitive=true; else txtDecoy.Sensitive=false;
	   comanda();
	}
	public void on_txtDevice_changed(object o, EventArgs args)
	{
	    comanda();
	}
	public void on_txtPort_changed(object o, EventArgs args)
	{
	    comanda();
	}
	public void on_txtIP_changed(object o, EventArgs args)
	{
	    comanda();
	}
	public void on_txtDecoy_changed(object o, EventArgs args)
	{
	    comanda();
	}
	public void on_ckFragmentation_toggled(object o, EventArgs args)
	{
	    comanda();
	}
	public void on_ckIPv6_toggled(object o, EventArgs args)
	{
	    comanda();
	}
	public void on_ckOrderedPorts_toggled(object o, EventArgs args)
	{
	    comanda();
	}
	public void on_ckTTL_toggled(object o, EventArgs args)
	{
	    if(ckTTL.Active==true) sbTTL.Sensitive=true; else sbTTL.Sensitive=false;
	    comanda();
	}
	public void on_ckMinParallel_toggled(object o, EventArgs args)
	{	   
	    if(ckMinParallel.Active==true) sbMinParallel.Sensitive=true; else sbMinParallel.Sensitive=false;
	    comanda();
	}
	public void on_ckMaxParallel_toggled(object o, EventArgs args)
	{	   	  
	    if(ckMaxParallel.Active==true) sbMaxParallel.Sensitive=true; else sbMaxParallel.Sensitive=false;    
	    comanda();
	}
	public void on_sbTTL_changed(object o, EventArgs args)
	{	   	  
	    comanda();
	}
	public void on_sbMinParallel_changed(object o, EventArgs args)
	{	   	   
	    comanda();
	}
	public void on_sbMaxParallel_changed(object o, EventArgs args)
	{	   	   
	    comanda();
	}
	public void on_ckInitRTT_toggled(object o, EventArgs args)
	{	   
	    if(ckInitRTT.Active==true) sbInitRTT.Sensitive=true; else sbInitRTT.Sensitive=false;
	    comanda();
	}
	public void on_ckMinRTT_toggled(object o, EventArgs args)
	{	   
	    if(ckMinRTT.Active==true) sbMinRTT.Sensitive=true; else sbMinRTT.Sensitive=false;
	    comanda();
	}
	public void on_ckMaxRTT_toggled(object o, EventArgs args)
	{	   
	    if(ckMaxRTT.Active==true) sbMaxRTT.Sensitive=true; else sbMaxRTT.Sensitive=false;
	    comanda();
	}
	public void on_ckHostTimeout_toggled(object o, EventArgs args)
	{	   
	    if(ckHostTimeout.Active==true) sbHostTimeout.Sensitive=true; else sbHostTimeout.Sensitive=false;
	    comanda();
	}
	public void on_ckScanDelay_toggled(object o, EventArgs args)
	{	   
	    if(ckScanDelay.Active==true) sbScanDelay.Sensitive=true; else sbScanDelay.Sensitive=false;
	    comanda();
	}
	public void on_sbInitRTT_changed(object o, EventArgs args)
	{	   	   
	    comanda();
	}
	public void on_sbMinRTT_changed(object o, EventArgs args)
	{	   	   
	    comanda();
	}
	public void on_sbMaxRTT_changed(object o, EventArgs args)
	{	   	   
	    comanda();
	}
	public void on_sbHostTimeout_changed(object o, EventArgs args)
	{	   	   
	    comanda();
	}
	public void on_sbScanDelay_changed(object o, EventArgs args)
	{	   	   
	    comanda();
	}
	public void on_btnInput_clicked(object o, EventArgs args)
	{
        FileSelection fs = new FileSelection ("Choose a file");
	    fs.Run ();
        txtInput.Text=fs.Filename;                 
        fs.Hide ();
	}
	public void on_btnOutput_clicked(object o, EventArgs args)
	{
	    FileSelection fs = new FileSelection ("Choose a file");
	    fs.Run ();
        txtOutput.Text=fs.Filename;                 
        fs.Hide ();
	}
	public void on_ckInputFile_toggled(object o, EventArgs args)
	{
		if(ckInputFile.Active==true ){ hbInput.Sensitive=true; }
		else{ hbInput.Sensitive=false; }
	}
	public void on_ckOutputFile_toggled(object o, EventArgs args)
	{
		if(ckOutputFile.Active==true ){ hbOutput.Sensitive=true; }
		else{ hbOutput.Sensitive=false; }
	}
	
	// thread notify
	public void ready ()
	{
			buffer.Text+=" ";
		btnScan.Sensitive=true;
	}			      
	public void scan()
	{

		
		buffer=txtvView.Buffer;
	    //redirect output of nmap to TextView
	    System.Diagnostics.ProcessStartInfo psi=new System.Diagnostics.ProcessStartInfo();
	    psi.FileName="nmap";
	    psi.Arguments=parametri;
	    psi.UseShellExecute = false;
	    psi.RedirectStandardOutput = true;
	    psi.RedirectStandardError = true;
	    System.Diagnostics.Process p =new System.Diagnostics.Process();
	    p.StartInfo=psi;
	    p.Start();
	    sr1=p.StandardOutput; sr2=p.StandardError;
		buffer.Text=sr1.ReadToEnd(); buffer.Text+=sr2.ReadToEnd();
		
		notify.WakeupMain ();
		Thread.Sleep(100);
	}
	public void comanda()
	{
		string etc; //misc. options
		Scan_ex="";Discover="";Source="";etc="";throttling_etc="";   
		if(chkRPC.Active==true && chkRPC.Sensitive==true){ Scan_ex+="-sR "; }
	    if(chkIdentd.Active==true && chkIdentd.Sensitive==true){ Scan_ex+="-I "; }
	    if(chkOsDetection.Active==true && chkOsDetection.Sensitive==true){ Scan_ex+="-O "; }
	    if(chkVersion.Active==true && chkVersion.Sensitive==true){ Scan_ex+="-sV "; }
	    if(ckTcpAck.Active==true ){ Discover+="-PT "+txtAckPort.Text+" "; }
	    if(ckIcmpEcho.Active==true ){ Discover+="-PI "; }
	    if(ckIcmpTimestamp.Active==true ){ Discover+="-PP "; }
	    if(ckIcmpNetmask.Active==true ){ Discover+="-PM "; }
	    if(ckTcpSyn.Active==true ){Discover+="-PS "+txtTcpSyn.Text+" "; }
	    if(ckUdpPing.Active==true ){Discover+="-PU "+txtUdpPing.Text+" "; }
	    if(ckDevice.Active==true){Source+="-e "+txtDevice.Text+" "; }
	    if(ckPort.Active==true){Source+="-g "+txtPort.Text+" "; }
	    if(ckIP.Active==true){Source+="-S "+txtIP.Text+" "; }
	    if(ckDecoy.Active==true){Source+="-D "+txtDecoy.Text+" "; }
	    if(ckFragmentation.Active==true){etc+="-f ";}
	    if(ckIPv6.Active==true){etc+="-6 ";}
	    if(ckOrderedPorts.Active==true){etc+="-r ";}  
	    if(ckTTL.Active==true){throttling_etc+="--ttl "+sbTTL.Text+" ";}
	    if(ckMinParallel.Active==true){throttling_etc+="--min_parallelism "+sbMinParallel.Text+" ";}
	    if(ckMaxParallel.Active==true){throttling_etc+="-M "+sbMaxParallel.Text+" ";}
	    if(ckInitRTT.Active==true){throttling_etc+="--initial_rtt_timeout "+sbInitRTT.Text+" ";}
	    if(ckMinRTT.Active==true){throttling_etc+="--min_rtt_timeout "+sbMinRTT.Text+" ";}
	    if(ckMaxRTT.Active==true){throttling_etc+="--max_rtt_timeout "+sbMaxRTT.Text+" ";}
	    if(ckHostTimeout.Active==true){throttling_etc+="--host_timeout "+sbHostTimeout.Text+" ";}
	    if(ckScanDelay.Active==true){throttling_etc+="--scan_delay "+sbScanDelay.Text+" ";}		
	    if(chkPing.Active==true){
			Discover="-P0 ";
			fPing.Sensitive=false;
		}
		else {
			if(uid!=0){
				fPing.Sensitive=true;
				ckTcpAck.Sensitive = true;
			}
			else{
				fPing.Sensitive=true;
				ckIcmpEcho.Sensitive =true;
				ckTcpAck.Sensitive = true;
				ckIcmpTimestamp.Sensitive = true;
				ckIcmpNetmask.Sensitive = true;
				ckTcpSyn.Sensitive = true;
				ckUdpPing.Sensitive = true;
			}
		} 
		parametri=scanValue+Scan_ex+scannedPorts+Discover+throttling+throttling_etc+Source+reversedns+verbosity+etc+txtTarget.Text;
		txtCommand.Text="nmap "+parametri;
	}
}
