#/bin/bash
## destroy.sh 
## Copyright (C) 2001 Cornett Wood 
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## To received a copy of the GNU General Public License, write to the
## Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

if [ $# != 1 ]; then
  echo "Must supply the configure file base name.  I'll put the cfg tag on." >&2
  exit 1
fi
if [ ! -f $1.cfg ]; then
  echo "Where is $1.cfg?" >&2
  exit 1
fi

PW=$2

source $1.cfg
TMP=/tmp/${SQLENGINE}$$

if [ -z "$SQLDB" ]; then
  echo "SQLDB not defined" >&2
  exit 1
fi

if [ x"$PW" != x ]; then
  PW="--password=$PW"
fi

# create the snort database (just a shell for now)
# delete the database
echo deleting database: $SQLDB
${SQLENGINE}admin $PW drop $SQLDB
# delete the snort user
echo deleting sql user: $SQLUSER
cat << EOF > $TMP
use ${SQLENGINE}
DELETE FROM user where user = '$SQLUSER';
EOF
cat $TMP | ${SQLENGINE}
${SQLENGINE}admin $PW reload
rm $TMP
