#!/bin/sh
## getacid.sh
## Copyright (C) 2001 Cornett Wood 
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## To received a copy of the GNU General Public License, write to the
## Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#export SQLENGINE=mysql
#export SQLDB=hog
#export SNORTSRC=/home/snort
#export ACIDSRC=/home/apache/htdocs/$SQLDB/acid
#export SQLUSER=hog
#export SQLHOST=one.sensor.com,two.sensor.com
#export PASSWORD=life-is-2-short

if [ $# != 1 ]; then
  echo "Must supply the configure file base name.  I'll put the cfg tag on." >&2
  exit 1
fi
if [ ! -f $1.cfg ]; then
  echo "Where is $1.cfg?" >&2
  exit 1
fi
DB=$1

source $DB.cfg

WEB_BASE=`dirname $ACIDSRC`
ACID=`basename $ACIDSRC`

pushd /tmp
rm -rf acid
cvs -d:pserver:anonymous@cvs.acidlab.sourceforge.net:/cvsroot/acidlab login
cvs -z3 -d:pserver:anonymous@cvs.acidlab.sourceforge.net:/cvsroot/acidlab co acid
popd

mkdir -p $WEB_BASE
pushd $WEB_BASE
if [ $? -eq 0 ]; then
  [ ! -d $ACID ] || rm -rf $ACID
  mkdir $ACID
  cd $ACID
  cp -r /tmp/acid/acid/[a-z]* .
  cp acid_conf.php acid_conf.php.orig

  sed < acid_conf.php.orig > acid_conf.php \
    -e 's#^\$alert_dbname[ 	]*=.*#\$alert_dbname = "'"$SQLDB"'";#' \
    -e 's#^\$alert_host[ 	]*=.*#\$alert_host = "'"$SQLSERVER"'";#' \
    -e 's#^\$alert_port[ 	]*=.*#\$alert_port = "'"$SQLPORT"'";#' \
    -e 's#^\$alert_user[ 	]*=.*#\$alert_user = "'"$SQLUSER"'";#' \
    -e 's#^\$alert_password[ 	]*=.*#\$alert_password = "'"$PASSWORD"'";#' \
    -e 's#^\$DBlib_path.*#\$DBlib_path = "'"$ADODB_PATH"'";#' \
    -e 's#^\$ChartLib_path.*#\$ChartLib_path = "'"$PHPLOT_PATH"'";#' \
    -e 's#^\$DBtype.*#\$DBtype = "'"$SQLENGINE"'";#'
else
  echo "web base: $WEB_BASE, does not exist!" >&2
  exit 1
fi
popd
h=`hostname`
set x `host $h`
echo you must add the update_priv to $SQLUSER@$2 in $SQLSERVER
