#!/bin/bash
## create.sh 
## Copyright (C) 2001 Cornett Wood 
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## To received a copy of the GNU General Public License, write to the
## Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

if [ $# -lt 0 ]; then
  echo "Must supply the configure file base name.  I'll put the cfg tag on." >&2
  exit 1
fi
if [ ! -f $1.cfg ]; then
  echo "Where is $1.cfg?" >&2
  exit 1
fi
PW=$2
  
source $1.cfg
TMP=/tmp/${SQLENGINE}$$

if [ -z "$SQLDB" ]; then
  echo "SQLDB not defined" >&2
  exit 1
fi

if [ x"$PW" != x ]; then
  PW="--password=$PW"
fi

# create the snort database (just a shell for now)
${SQLENGINE}admin $PW create $SQLDB
#
# create the snort user with select insert privileges
echo "use ${SQLENGINE}" > $TMP.local
for h in localhost $SQLSERVER; do
cat << EOF >> $TMP.local
INSERT INTO user  (host,user,password,select_priv,insert_priv,delete_priv,create_priv,update_priv)
            values('$h','$SQLUSER',password('$PASSWORD'),'Y','Y','Y','Y','Y');
EOF
done

for h in `echo $SQLHOST | sed -e 's/,/ /g'`; do
if [ "$SQLHOST" != "$SQLSERVER" ]; then
  cat << EOF >> $TMP.local
INSERT INTO user  (host,user,password,select_priv,insert_priv,delete_priv)
            values('$h','$SQLUSER',password('$PASSWORD'),'Y','Y','Y');
EOF
fi
done
if [ -s $TMP.local ]; then
cat $TMP.local | ${SQLENGINE}
${SQLENGINE}admin $PW reload
fi
#
# initialize the snort database
echo use $SQLDB | cat - $SNORTSRC/contrib/create_${SQLENGINE} | ${SQLENGINE}

echo use $SQLDB | cat - $ACIDSRC/create_acid_tbls_${SQLENGINE}.sql | ${SQLENGINE}

#rm $TMP.*
