/****************************************************************************
 *
 * Copyright (C) 2010-2011 Sourcefire, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License Version 2 as
 * published by the Free Software Foundation.  You may not use, modify or
 * distribute this program under any other version of the GNU General
 * Public License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 ****************************************************************************/

// @file    drx.c
// @author  Russ Combs <rcombs@sourcefire.com>

#include <stdio.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "sf_snort_plugin_api.h"
#include "sf_snort_packet.h"
#include "detection_lib_meta.h"

static inline void trace (int line, const char* msg)
{
#ifdef DEBUG
    printf("%s:%d: %s\n", __FILE__, line, msg);
#endif
}

//---------------------------------------------------------------
// flow:established,to_server;

static FlowFlags infoFlow =
{
    FLOW_ESTABLISHED | FLOW_TO_SERVER
};

static RuleOption optFlow =
{
    OPTION_TYPE_FLOWFLAGS,
    { &infoFlow }
};

//---------------------------------------------------------------
// content:"waldo"; nocase;

static ContentInfo infoContent =
{
    (uint8_t*)"waldo",
    0, 0,
    CONTENT_NOCASE,
    NULL, NULL,
    0, 0, 0, 0, 0,
    NULL, NULL, NULL, NULL
};

static RuleOption optContent =
{
    OPTION_TYPE_CONTENT,
    { &infoContent }
};

//---------------------------------------------------------------
// flowbits:toggle "drx";

static FlowBitsInfo infoToggle =
{
    "drx",
    FLOWBIT_TOGGLE,
    0, 0
};

static RuleOption optToggle =
{
    OPTION_TYPE_FLOWBIT,
    { &infoToggle }
};

//---------------------------------------------------------------
// flowbits:isset "drx";

static FlowBitsInfo infoTest =
{
    "drx",
    FLOWBIT_ISSET,
    0, 0
};

static RuleOption optTest =
{
    OPTION_TYPE_FLOWBIT,
    { &infoTest }
};


//---------------------------------------------------------------

static RuleOption* drxOptions[] =
{
    &optFlow,
    &optContent,
    &optToggle,
    &optTest,
    NULL
};

//---------------------------------------------------------------

static int drx_eval (void* p)
{
    const uint8_t* cursor = NULL;
    trace(__LINE__, "drx eval");

    if ( !checkFlow(p, optFlow.option_u.flowFlags) )
        return RULE_NOMATCH;

    if ( !contentMatch(p, optContent.option_u.content, &cursor) )
        return RULE_NOMATCH;

    trace(__LINE__, "drx toggle");
    processFlowbits(p, optToggle.option_u.flowBit);

    if ( !processFlowbits(p, optTest.option_u.flowBit) )
        return RULE_NOMATCH;

    trace(__LINE__, "drx match");
    return RULE_MATCH;
}

//---------------------------------------------------------------

static Rule drx =
{
   // alert tcp any any -> any any
   {
       IPPROTO_TCP,
       "any", "any",
       0,
       "any", "any",
   },
   // gid:3; sid:1; rev:1; msg:"DRX";
   {
       3, 1, 1,
       NULL,
       0,
       "DRX found WALDO",
       NULL, NULL
   },
   drxOptions,
   drx_eval,
   0, 0, 0,
   NULL
};

Rule* rules[] =
{
    &drx,
    NULL
};

